#include "CGameLogic.h"
#include "CLevel.h"
#include "CSoundManager.h"

CGameLogic::CGameLogic()
{
  ResetGame();
  SetShowGameScreen(false);
  SetScreenShot(0);
  SetGameMode(C_MODE_TITLE);
}


CGameLogic::~CGameLogic()
{
    
    
}

void CGameLogic::SetLevelPlayTimeInSeconds(int i_secs)
{
    m_i_level_play_time_ms = i_secs *1000;
}

void CGameLogic::SetLevel(int i_new)
{
    assert(GetApp()->GetLevel() && "The Level should be initted before the game logic!");
    m_i_level = i_new;
    m_f_health = 0.0001f;
    m_f_damage = 0.00003f;
    m_f_sickness_missed = 0.000f;
    m_f_target_health = 0.75f;
    m_f_last_health_ratio = 0;
    
   
   GetApp()->GetLevel()->Reset(); //clear out everything to defaults
   //set default placements for the walls
   GetApp()->GetLevel()->GetLeftWall()->SetWidth(10);
   GetApp()->GetLevel()->GetLeftWall()->SetX(240);
   GetApp()->GetLevel()->GetLeftWall()->SetPSWidth(10);
   
   GetApp()->GetLevel()->GetRightWall()->SetX(396);
   GetApp()->GetLevel()->GetRightWall()->SetWidth(10);
   GetApp()->GetLevel()->GetLeftWall()->SetOutputMode(C_OUTPUT_MODE_NORMAL);
   GetApp()->GetLevel()->GetRightWall()->SetOutputMode(C_OUTPUT_MODE_NORMAL);
   GetApp()->GetLevel()->GetLeftWall()->SetMovementStyle(0);
   GetApp()->GetLevel()->GetRightWall()->SetMovementStyle(0);
   
   
   SetLevelPlayTimeInSeconds(15);

   m_p_st_message = "No text for this mission!";
   
   if (m_i_level == 1)
   {
    m_f_target_health = 0.80f;
    GetApp()->GetLevel()->GetRightWall()->SetDisabled(true);
    GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(250,400);
    GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(500,1200);
    GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(60); //lines per second
    
    m_p_st_message = 
    "                        - Mission 1 -\n\n"\
    "After being injected into your wife's\n"\
    "body you fly to the stomach.\n\n"\
    "Destroy the diseased lining (RED),\n"\
    "but be careful not to hit the healthy\n"\
    "(GREEN) tissue or you'll cause severe\n"\
    "damage."\
    ;
    
    
   }

   if (m_i_level == 2)
   {
      
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(180,250);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(350,500);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(120); //lines per second

       GetApp()->GetLevel()->GetRightWall()->SetHealthySpeed(300,400);
       GetApp()->GetLevel()->GetRightWall()->SetSickSpeed(1300,3900);
       GetApp()->GetLevel()->GetRightWall()->SetMovementSpeed(120); //lines per second
       m_p_st_message = 
           "                        - Mission 2 -\n\n"\
           "You enter the intestinal arteries.\n"\
           "You must destroy encroaching\n"\
           "bacteria on both sides.\n"\
           ;
       m_f_target_health = 0.8f;
       SetLevelPlayTimeInSeconds(25);
   }
  
   if (m_i_level == 3)
   {
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(180,250);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(350,500);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(200); //lines per second
       
       GetApp()->GetLevel()->GetRightWall()->SetHealthySpeed(400,700);
       GetApp()->GetLevel()->GetRightWall()->SetSickSpeed(600,1200);
       GetApp()->GetLevel()->GetRightWall()->SetMovementSpeed(50); //lines per second
       m_p_st_message = 
           "                        - Mission 3 -\n\n"\
           "The Retromandibular Vein is\n"\
           "next on the list.  Her vital signs\n"\
           "are stronger, but you have more work\n"\
           "to do."
           ;
       m_f_target_health = 0.7f;
       SetLevelPlayTimeInSeconds(30);
       
   }

   if (m_i_level == 4)
   {
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(180,250);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(350,500);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(300); //lines per second
       GetApp()->GetLevel()->GetLeftWall()->SetMovementStyle(2);
       GetApp()->GetLevel()->GetRightWall()->SetDisabled(true);
       m_p_st_message = 
           "                        - Mission 4 -\n\n"\
           "Sensors indicate DNA virus\n"\
           "infiltration that will contaminate\n"\
           "offspring. You don't have much time.\n"\
           ;
       m_f_target_health = 0.85f;
       
       SetLevelPlayTimeInSeconds(30);
       
   }
   
   if (m_i_level == 5)
   {
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(180,250);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(350,500);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(500); //lines per second
       
       GetApp()->GetLevel()->GetRightWall()->SetHealthySpeed(400,700);
       GetApp()->GetLevel()->GetRightWall()->SetSickSpeed(600,1200);
       GetApp()->GetLevel()->GetRightWall()->SetMovementSpeed(500); //lines per second
       m_p_st_message = 
           "                        - Mission 5 -\n\n"\
           "Good work, but before you get cocky\n"\
           "take a deep breath and enter the lung\n"\
           "area.  It's infected as well.\n"\
           ;
       m_f_target_health = 0.8f;
       SetLevelPlayTimeInSeconds(30);
       
   }

   if (m_i_level == 6)
   {
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(180,250);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(350,500);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(500); //lines per second
       
       GetApp()->GetLevel()->GetRightWall()->SetMovementStyle(3);
       GetApp()->GetLevel()->GetRightWall()->SetHealthySpeed(400,700);
       GetApp()->GetLevel()->GetRightWall()->SetSickSpeed(600,1200);
       GetApp()->GetLevel()->GetRightWall()->SetMovementStyle(3);
       GetApp()->GetLevel()->GetRightWall()->SetMovementSpeed(500); //lines per second
       m_p_st_message = 
           "                        - Mission 6 -\n\n"\
           "After decontaminating the lungs you.\n"\
           "start to feel vibrations.  She must be\n"\
           "coughing.  Don't let it effect your aim.\n"\
           ;
       m_f_target_health = 0.8f;
       SetLevelPlayTimeInSeconds(20);
       
   }

   if (m_i_level == 7)
   {
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(400,401);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(400,401);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(60); //lines per second
       
       GetApp()->GetLevel()->GetRightWall()->SetHealthySpeed(400,401);
       GetApp()->GetLevel()->GetRightWall()->SetSickSpeed(400,401);
//       GetApp()->GetLevel()->GetRightWall()->SetMovementStyle(3);
       GetApp()->GetLevel()->GetRightWall()->SetMovementSpeed(60); //lines per second
       m_p_st_message = 
           "                        - Mission 7 -\n\n"\
           "You enter the brain.  Be careful,\n"\
           "a missfired shot could create brain\n"\
           "damage.\n"\
           ;
       m_f_target_health = 0.8f;
       SetLevelPlayTimeInSeconds(30);
       
   }

   if (m_i_level == 8)
   {
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(400,401);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(400,401);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(120); //lines per second
       GetApp()->GetLevel()->GetLeftWall()->SetMovementStyle(2);
       
       GetApp()->GetLevel()->GetRightWall()->SetHealthySpeed(400,401);
       GetApp()->GetLevel()->GetRightWall()->SetSickSpeed(400,401);
       GetApp()->GetLevel()->GetRightWall()->SetMovementStyle(2);
       GetApp()->GetLevel()->GetRightWall()->SetMovementSpeed(120); //lines per second
       m_p_st_message = 
           "                        - Mission 8 -\n\n"\
           "You are lost in the brain and\n"\
           "confused.  You must be more accurate\n"\
           "then ever before here.\n"\
           ;
       m_f_target_health = 0.830f;
       SetLevelPlayTimeInSeconds(30);
       
   }

   if (m_i_level == 9)
   {
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(100,110);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(100,110);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(200); //lines per second
       GetApp()->GetLevel()->GetLeftWall()->SetMovementStyle(0);
       GetApp()->GetLevel()->GetLeftWall()->SetWidth(3);
       GetApp()->GetLevel()->GetLeftWall()->SetPSWidth(3);
       
       GetApp()->GetLevel()->GetRightWall()->SetHealthySpeed(10,40);
       GetApp()->GetLevel()->GetRightWall()->SetSickSpeed(3000,8000);
       GetApp()->GetLevel()->GetRightWall()->SetMovementStyle(0);
       GetApp()->GetLevel()->GetRightWall()->SetMovementSpeed(200); //lines per second
       m_p_st_message = 
           "                        - Mission 9 -\n\n"\
           "You are riding along side her\n"\
           "optical nerve.  It's far too thin,\n"\
           "this may be why she was going blind.\n"\
           ;
       m_f_target_health = 0.761f;
       SetLevelPlayTimeInSeconds(30);
       
   }

   if (m_i_level == 10)
   {
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(200,300);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(300,600);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(330); //lines per second
       GetApp()->GetLevel()->GetLeftWall()->SetMovementStyle(0);
       GetApp()->GetLevel()->GetLeftWall()->SetColorMode(1);
       
       GetApp()->GetLevel()->GetRightWall()->SetHealthySpeed(300,600);
       GetApp()->GetLevel()->GetRightWall()->SetSickSpeed(300,600);
       GetApp()->GetLevel()->GetRightWall()->SetMovementStyle(0);
       GetApp()->GetLevel()->GetRightWall()->SetMovementSpeed(400); //lines per second
       GetApp()->GetLevel()->GetRightWall()->SetColorMode(1);
       m_p_st_message = 
           "                        - Mission 10 -\n\n"\
           "You sense eye movement. She must\n"\
           "have entered REM sleep.\n"\
           "\n"\
           "The colors.\n\nStay focused."\
           ;
       m_f_target_health = 0.831f;
       
   }

   if (m_i_level == 11)
   {
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(200,300);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(400,500);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(120); //lines per second
       GetApp()->GetLevel()->GetLeftWall()->SetMovementStyle(0);
       GetApp()->GetLevel()->GetLeftWall()->SetColorMode(2);
       
       GetApp()->GetLevel()->GetRightWall()->SetHealthySpeed(200,300);
       GetApp()->GetLevel()->GetRightWall()->SetSickSpeed(400,500);
       GetApp()->GetLevel()->GetRightWall()->SetMovementStyle(0);
       GetApp()->GetLevel()->GetRightWall()->SetMovementSpeed(120); //lines per second
       GetApp()->GetLevel()->GetRightWall()->SetColorMode(2);
       m_p_st_message = 
           "                        - Mission 11 -\n\n"\
           "You will cross the suspensory\n"\
           "ligament, it will only take a second\n"\
           "but it is vital that you not miss.\n"\
           ;
       m_f_target_health = 0.851f;
       SetLevelPlayTimeInSeconds(7);
       
   }
  
   if (m_i_level == 12)
   {
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(100,200);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(400,900);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(120); //lines per second
       GetApp()->GetLevel()->GetLeftWall()->SetMovementStyle(4);
       GetApp()->GetLevel()->GetLeftWall()->SetColorMode(2);
       
       GetApp()->GetLevel()->GetRightWall()->SetHealthySpeed(100,200);
       GetApp()->GetLevel()->GetRightWall()->SetSickSpeed(600,900);
       GetApp()->GetLevel()->GetRightWall()->SetMovementStyle(4);
       GetApp()->GetLevel()->GetRightWall()->SetMovementSpeed(120); //lines per second
       GetApp()->GetLevel()->GetRightWall()->SetColorMode(2);
       m_p_st_message = 
           "                        - Mission 12 -\n\n"\
           "As you near the throat, your wife\n"\
           "begins to scream.  The sound waves\n"\
           "carry the virus? They are never going\n"\
           "to believe this back home.\n"\
           ;
       m_f_target_health = 0.901f;
       SetLevelPlayTimeInSeconds(13);
   }
   
   
   if (m_i_level == 13)
   {
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(500,600);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(100,150);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(120); //lines per second
       GetApp()->GetLevel()->GetLeftWall()->SetMovementStyle(0);
       //GetApp()->GetLevel()->GetLeftWall()->SetColorMode(2);
       
       GetApp()->GetLevel()->GetRightWall()->SetHealthySpeed(500,600);
       GetApp()->GetLevel()->GetRightWall()->SetSickSpeed(100,150);
       GetApp()->GetLevel()->GetRightWall()->SetMovementStyle(0);
       GetApp()->GetLevel()->GetRightWall()->SetMovementSpeed(120); //lines per second
      // GetApp()->GetLevel()->GetRightWall()->SetColorMode(2);
     m_p_st_message = 
           "                        - Mission 13 -\n\n"\
           "The brain is cleansed. You fall down\n"\
           "the esophagus.  To your suprise the\n"
           "virus seems to be dying on it's own\n"
           " here, the walls are mostly healthy.\n"
           ;
       m_f_target_health = 0.701f;
       SetLevelPlayTimeInSeconds(25);
       
   }
   if (m_i_level == 14)
   {
       GetApp()->GetLevel()->GetLeftWall()->SetHealthySpeed(100,300);
       GetApp()->GetLevel()->GetLeftWall()->SetSickSpeed(200,350);
       GetApp()->GetLevel()->GetLeftWall()->SetMovementSpeed(200); //lines per second
       GetApp()->GetLevel()->GetLeftWall()->SetMovementStyle(5);
       //GetApp()->GetLevel()->GetLeftWall()->SetColorMode(2);
       
       GetApp()->GetLevel()->GetRightWall()->SetHealthySpeed(100,300);
       GetApp()->GetLevel()->GetRightWall()->SetSickSpeed(200,350);
       GetApp()->GetLevel()->GetRightWall()->SetMovementStyle(0);
       GetApp()->GetLevel()->GetRightWall()->SetMovementSpeed(200); //lines per second
       GetApp()->GetLevel()->GetRightWall()->SetMovementStyle(5);
       m_p_st_message = 
           "                   - LAST MISSION -\n\n"\
           "It's time to exit the body.  You will\n"\
           "leave through the colon. Be careful, as\n"
           "involuntary contractions will shift\n"
           "the lower intestines.\n"
           ;
       m_f_target_health = 0.771f;
       SetLevelPlayTimeInSeconds(25);
       
   }
}

void CGameLogic::SetGameMode(int i_mode)
{
   //disabled mode timer as the default
    m_ui_mode_timer = 0;
    
    switch (i_mode)
    {
    case C_MODE_GET_READY:
        SetLevel(m_i_level); //set it again to reset the timers
        m_b_wait_for_space = true;
        GetApp()->GetSound()->Play(C_SOUND_START);
        SetShowGameScreen(false);
        
        break;
        
    case C_MODE_PLAY:
        SetLevel(m_i_level); //set it again to reset the timers
        m_ui_mode_timer = GetApp()->GetGameTime() +  m_i_level_play_time_ms;
        SetShowGameScreen(true);
        
        break;
    case C_MODE_PLAY_OVER:
        m_ui_mode_timer = GetApp()->GetGameTime() +  12000;
        GetApp()->GetLevel()->GetLeftWall()->SetOutputMode(C_OUTPUT_MODE_NONE); //stop creating new walls
        GetApp()->GetLevel()->GetRightWall()->SetOutputMode(C_OUTPUT_MODE_NONE); //stop creating new walls
        break;
    case C_MODE_RESULT:
        m_ui_mode_timer = GetApp()->GetGameTime() +  3700;
        if (m_f_last_health_ratio >= m_f_target_health)
        {
            GetApp()->GetSound()->Play(C_SOUND_HAPPY);
        }
            break;
    case C_MODE_FAILED:
        m_b_wait_for_space = true;
        GetApp()->GetSound()->Play(C_SOUND_START);
        SetShowGameScreen(false);
        SetScreenShot("graphics\\failed.jpg");
        break;
    case C_MODE_TITLE:
        m_b_wait_for_space = true;
        GetApp()->GetSound()->Play(C_SOUND_START);
        SetShowGameScreen(false);
        SetScreenShot("graphics\\title.jpg");
        break;
    case C_MODE_START_STORY:
        m_b_wait_for_space = true;
         SetShowGameScreen(false);
        SetScreenShot("graphics\\intro.jpg");
        break;
    case C_MODE_WON:
        m_b_wait_for_space = true;
        GetApp()->GetSound()->Play(C_SOUND_START);
        SetShowGameScreen(false);
        SetScreenShot("graphics\\success.jpg");
        break;
        
        
    default:
        assert(!"Don't know how to handle this mode");
    }
    
    m_i_mode = i_mode;
}

//send it a null to cancel showing the screen
void CGameLogic::SetScreenShot(char *p_st_name)
{
    if (!p_st_name)
    {
        m_st_screenshot_name[0] = 0; 
    } else
    {
     strcpy(m_st_screenshot_name, p_st_name);
     m_screenshot.Create(GetApp()->GetScreen(),m_st_screenshot_name,  0,0,1);

     
    }
}
void CGameLogic::AdvanceGameMode()
{
    //well, a timer is actie and got triggered, let's see what that is about
    switch (m_i_mode)
    {
    case C_MODE_GET_READY:
        //stop showing the intro message and let them play already
        SetGameMode(C_MODE_PLAY);
        break;
    case C_MODE_PLAY:
        SetGameMode(C_MODE_PLAY_OVER);
        break;
    case C_MODE_PLAY_OVER:
        SetGameMode(C_MODE_RESULT);
            break;
    case C_MODE_RESULT:
        
        if (m_f_last_health_ratio >= m_f_target_health)
        {
          
            if (m_i_level == C_TOTAL_LEVELS)
            {
                //they just finished the last one
                SetGameMode(C_MODE_WON);
            } else
            {
            SetLevel(m_i_level +1);
            SetGameMode(C_MODE_GET_READY);
            }
        } else
        {
            //they failed
            SetGameMode(C_MODE_FAILED);
        }
        break;
    case C_MODE_FAILED:
        SetGameMode(C_MODE_TITLE);
        break;
    case C_MODE_TITLE:
        SetGameMode(C_MODE_START_STORY);
        break;
    case C_MODE_WON:
        SetGameMode(C_MODE_TITLE);
        break;
        
    case C_MODE_START_STORY:
        
        ResetGame();
        SetGameMode(C_MODE_GET_READY);
        break;
        
    default:
        assert(!"Huh?");
    }
}

void CGameLogic::ContinueLastGame()
{
   if (GetGameMode() == C_MODE_TITLE)
   {
   int  m_i_temp = m_i_level;
    ResetGame();
    m_i_level = m_i_temp;
    SetScreenShot(0);
    SetGameMode(C_MODE_GET_READY);
   }
}
void CGameLogic::ResetGame()
{
    m_i_level = 1;
    m_f_score = 0;
  
     m_b_wait_for_space = false;
    SetLevel(1);
}



void CGameLogic::IncHealthHit()
{

    m_f_damage += 0.001f;
    m_f_score -= 10 * m_f_last_health_ratio;
    if (m_f_score < 0) m_f_score = 0;
    
}

void CGameLogic::IncSickHit()
{
    
    m_f_health += 0.001f;
    m_f_score += 1 * m_f_last_health_ratio;
    
}

void CGameLogic::IncSickMissed()
{
    m_f_sickness_missed += 0.0004f;
}

void CGameLogic::Update()
{
 
    if (m_ui_mode_timer != 0 && m_ui_mode_timer < GetApp()->GetGameTime())
    {
       AdvanceGameMode();
    }
}

void CGameLogic::HitSpace()
{
    if (m_b_wait_for_space)
    {
      m_b_wait_for_space = false;
      SetScreenShot(0); //clear it out
      AdvanceGameMode();
    }
}
void CGameLogic::Render(CDXSurface *p_surf)
{
    char str[256]; 
    if (m_i_mode == C_MODE_GET_READY)
    {
        //show the message
        GetApp()->GetFont()->DrawTrans(30,50, m_p_st_message, p_surf);
        
        //draw info applicabel to every level

        sprintf(str, "Target Health: %%%d", int(m_f_target_health*100));
        GetApp()->GetFont()->DrawTrans(160,380, str, p_surf);
        
        GetApp()->GetFont()->DrawTrans(130,430, "Press SPACE to continue", p_surf);
        return;
    }
  
   
    
    if (GetApp()->GetDebug())
    {
        
        sprintf(str, "Sickness Cured: %.2f", m_f_health);        // Write formatted data to a string. 
        p_surf->GetDC(); 
        p_surf->SetFont();  //this shouldn't be used, but I don't want to break
        //the weird music problem this fixes
        p_surf->TextXY(20, 320, 255, str); // TextXY(x, y, color, string)
        sprintf(str, "Damage Done: %.2f", m_f_damage);        // Write formatted data to a string. 
        p_surf->TextXY(20, 333, 255, str); // TextXY(x, y, color, string)
        sprintf(str, "Sickness Missed: %.2f", m_f_sickness_missed);        // Write formatted data to a string. 
        p_surf->TextXY(20, 356, 255, str); // TextXY(x, y, color, string)
        
        p_surf->ReleaseDC();
    }

    
    //based on the above #'s, let's figure out our overall health
    
    float f_badness = (m_f_damage*2) + (m_f_sickness_missed*0.7f);
    
    GetApp()->GetFont()->DrawTrans(275,150, "Health", p_surf);
    //avoid a devide by zero error
    if (f_badness + m_f_damage != 0)
    {
        m_f_last_health_ratio = m_f_health / (f_badness + m_f_health);
         
        sprintf(str,"%%%d", int(m_f_last_health_ratio*100));
        GetApp()->GetFont()->DrawTrans(285,180, str, p_surf);
    } else
    {
        GetApp()->GetFont()->DrawTrans(280,180, "(wait)", p_surf);
          
    }
  if (GetGameMode() != C_MODE_RESULT)
  {
    sprintf(str,"(need %%%d)", int(m_f_target_health *100));
    p_surf->TextXY(290,137, 255, str); // TextXY(x, y, color, string)
  }
    
     //extra message to make it obvious what bad for new players (level 1 only)
     if (m_i_mode == C_MODE_PLAY && m_i_level == 1) 
     {
         
         
         if (GetApp()->GetLevel()->GetLeftWall()->GetLastWallTypeHit() == C_WALL_HEALTHY ||
             GetApp()->GetLevel()->GetRightWall()->GetLastWallTypeHit() == C_WALL_HEALTHY)
         {
             int i_rand = Random(1);
             int i_y = RandomRange(250, 255);
             int i_x = RandomRange(410,415);
             
             switch(i_rand)
             {
             case 0:
                 
                 GetApp()->GetFont()->DrawTrans(i_x,i_y, "Don't hit\ngreen!", p_surf);
                 break;
             default:
                 assert(!"Dumbass!");
                 
             }
         }
     }

     


     if (m_i_mode == C_MODE_RESULT)
     {
       if (m_f_last_health_ratio >= m_f_target_health)
       {
         sprintf(str, "      MISSION ACCOMPLISHED\nHealth target of %%%d was met.", int(m_f_target_health*100));
         //show results
         GetApp()->GetFont()->DrawTrans(90,60,str , p_surf);
       } else
       {
           
           sprintf(str, "             MISSION FAILED\n      Health target was %%%d.", int(m_f_target_health*100));
           //show results
           GetApp()->GetFont()->DrawTrans(90,60,str , p_surf);
       }
         
     }
  
     
     if (m_st_screenshot_name[0] != 0)
     {
         m_screenshot.DrawBlk(p_surf, 0,0);
     }
     
     sprintf(str, "Score: %d",int(m_f_score));        // Write formatted data to a string. 
     GetApp()->GetFont()->DrawTrans(400,4,str , p_surf);
     
     if (GetGameMode() == C_MODE_PLAY_OVER)
     {
         //if nothing is on the screen, let's hurry up the timer
         if (GetApp()->GetLevel()->IsEmpty())
         {
             m_ui_mode_timer = 1; //trigger it right now
         }
     }
     
     if (m_b_wait_for_space && GetGameMode() != C_MODE_TITLE) //the title screen already says press space to continue on it
     {
         GetApp()->GetFont()->DrawTrans(130,440, "Press SPACE to continue", p_surf);
         
     }
}

void CGameLogic::CheatModLevel(int i_mod)
{

    if (GetApp()->GetDebug())
    {
    
    SetLevel(m_i_level+i_mod);
    
    if (m_i_level > C_TOTAL_LEVELS)
    {
        m_i_level = C_TOTAL_LEVELS;
        SetLevel(m_i_level);
    }

    if (m_i_level < 1)
    {
        m_i_level = 1;
        SetLevel(m_i_level);
        
    }


    SetGameMode(C_MODE_GET_READY);
    SetScreenShot(0);
    }
}
