#pragma once

#include "CGlobals.h"

enum
{

  C_MODE_GET_READY,
      C_MODE_PLAY,
      C_MODE_PLAY_OVER, //wait for the crap to get off the screen
      C_MODE_ENDING,
      C_MODE_RESULT,
      C_MODE_FAILED,
      C_MODE_TITLE,
      C_MODE_START_STORY,
      C_MODE_WON
};

#define C_TOTAL_LEVELS 14

class CGameLogic
{
    
public:
    CGameLogic();
    ~CGameLogic();

    void IncSickHit(); //good
    void IncHealthHit(); //bad
    void IncSickMissed();
    
    void Update();
    void Render(CDXSurface *p_surf);
        
    void SetGameMode(int i_mode);
    int GetGameMode(){return m_i_mode;}
    void HitSpace();
    void SetLevelPlayTimeInSeconds(int i_secs);
    void SetShowGameScreen(bool b_new) {m_b_show_game_screen = b_new;}
    bool GetShowGameScreen(){return m_b_show_game_screen;}
    void SetScreenShot(char *p_st_name);
    void CheatModLevel(int i_mod);
    void ContinueLastGame();
         
    
private:

    void AdvanceGameMode();
    void ResetGame();
    void SetLevel(int i_new);
    
    
    float m_f_health;
    int m_i_level; //what level we're on
    float m_f_score;
    float m_f_damage; //how much damage they've done
    float m_f_sickness_missed;
    int m_i_mode;
    unsigned int m_ui_mode_timer;
    char * m_p_st_message;
    bool m_b_wait_for_space;
    int m_i_level_play_time_ms;
    float m_f_target_health;
    float m_f_last_health_ratio;
    bool m_b_show_game_screen;
    char m_st_screenshot_name[MAX_PATH];
    CDXTile m_screenshot; //for showing stills
    
};


