#include "CGlobals.h"
#include "CGameLogic.h"
#include "CLevel.h"
#include "CPlayer.h"
#include "CSoundManager.h"
#include "CParticleManager.h"

CGlobals g_glo;
CGlobals * GetApp(){return &g_glo;}

CGlobals::CGlobals()
{
    memset(this, 0, sizeof(*this));
    srand( (unsigned)GetTickCount() ); //set the random seed based on the clock time
    strcpy(m_st_app_name,"InnerBody"); //we'll use this throughout the app
    m_pnt_screen.x = 640;
    m_pnt_screen.y = 480; //we'll refer to this throughout the app
    m_b_windowed = false;
    SetDefaultWindowedStyle(WS_CAPTION |WS_MINIMIZEBOX |WS_SYSMENU| DS_CENTER);
    ResetDeltaNextFrame();
    
}

CGlobals::~CGlobals()
{
  //kill all the crap we'd initted
   LogMsg("Killing everything.");
   SAFE_DELETE(m_p_font1);
   SAFE_DELETE(m_p_particle_manager);
   SAFE_DELETE(m_p_player);
   SAFE_DELETE(m_p_game_logic);
   SAFE_DELETE(m_p_level);
   SAFE_DELETE(m_p_sound_manager);
   SAFE_DELETE(m_screen);
}


//***************** ONE TIME INIT *******************

bool CGlobals::InitGraphics()
{
    m_screen = new CDXScreen();                  // Create the CDXScreen object
    if (!m_screen)
    {
        LogMsg("Unable to init screen");
        return false;
    }
    
    if (!GetWindowedMode())
    {
       RemoveCaptionBarFromWindowStyle();
       if (0 > m_screen->CreateFullScreen(m_hwnd_main, GetScreenX(), GetScreenY(), GetBPP(), false))
       {
           MessageBox(m_hwnd_main, "Couldn't initialize window.  Old comp? I dunno", "Error",0);
           PostQuitMessage(0);
       }
        
    } else
    {
        m_screen->CreateWindowed(m_hwnd_main, GetScreenX(), GetScreenY());
    }
    ShowWindow(m_hwnd_main, SW_SHOWNORMAL);    // Show the window on the screen 
    UpdateWindow(m_hwnd_main);          // Show the window on the screen

    //initalize our manager objects that do most of the work.  no time for error checking, homes
    m_p_sound_manager = new CSoundManager();
    m_p_level = new CLevel();
    m_p_game_logic = new CGameLogic();
    m_p_player = new CPlayer();
    m_p_font1 = new CDXBitmapFont();
    m_p_particle_manager = new CParticleManager();

    if (0 > m_p_font1->CreateFromFile(m_screen, "graphics\\font1.bmp", 32, 32, 32, 128))
    {
        BadError("Couldn't load the font");
    }
 
    return true; //no probs I guess
}



void CGlobals::UpdateEverything()
{
    GetLevel()->Update();
    GetPlayer()->Update();
    GetGameLogic()->Update();
    GetPM()->Update();

}

void CGlobals::RenderEverything()
{
    if (!GetScreen()->GetBack())
    {
        assert(!"Unable to get back buffer.");
        return;
    }
    GetScreen()->GetBack()->Fill(RGB(0,0,0));
    
    GetLevel()->Render(m_screen->GetBack());
    GetPlayer()->Render(m_screen->GetBack());
    GetGameLogic()->Render(m_screen->GetBack());
    GetPM()->Render(m_screen->GetBack());

    if (GetApp()->GetDebug())
    {
        DrawFPS();
    }
    
    GetScreen()->Flip(false,false,false); 
 
} 

void CGlobals::DrawFPS()
{
        char str[256]; 
        sprintf(str, "FPS: %.2f", GetFPS());        // Write formatted data to a string. 
        GetScreen()->GetBack()->GetDC(); 
        GetScreen()->GetBack()->SetFont();  //this shouldn't be used, but I don't want to break
        //the weird music problem this fixes
        GetScreen()->GetBack()->TextXY(5, 5, 255, str); // TextXY(x, y, color, string)
       GetScreen()->GetBack()->ReleaseDC();
   
}
void CGlobals::ResetDeltaNextFrame()
{
    m_b_reset_delta_next_frame = true;
}


void CGlobals::UpdateTick()
{
    
    m_ui_time_last = m_ui_time;
    m_ui_time = GetTickCount();
    if (m_ui_time_last == 0) m_ui_time_last = m_ui_time;
    
    //calculate our delta time for framerate independent movement.
    
    if (m_ui_time - m_ui_time_last != 0)
    {
        m_f_delta = (float(m_ui_time-m_ui_time_last)/1000);
    }
    if (m_b_reset_delta_next_frame)
    {
        m_b_reset_delta_next_frame = false;
        m_f_delta = 0; 
        //we're told not to count this cycle, perhaps we just loaded something big and slow and don't
        //want to screw up our timing too much.
    }
     
    m_i_elapsed_frames++;
    
    if (m_ui_fps_counter < m_ui_time )
    {
        //time to calculate the frames per second
        m_f_fps = float(m_i_elapsed_frames);
        m_i_elapsed_frames = 0;
        m_ui_fps_counter = m_ui_time + 1000;
    }
    
}

void LogMsg(const char *lpFormat, ...)
{
    va_list Marker;
    char szBuf[4048];
    va_start(Marker, lpFormat);
    vsprintf(szBuf, lpFormat, Marker);
    va_end(Marker);
    char stTemp[4048];
    sprintf(stTemp, "%s\r\n", szBuf);
    OutputDebugString(stTemp);
}

void CGlobals::RestoreSurfaces()
{
    if (GetPlayer())
    GetPlayer()->Restore();
if (m_p_font1)
{
    if (0 > this->m_p_font1->CreateFromFile(m_screen, "graphics\\font1.bmp", 32, 32, 32, 128))
    {
        BadError("Couldn't load the font");
    }
}   
    LogMsg("Restoring surfaces");

    if (this->GetWindowedMode())
    {
        ShowCursor(true);
    } else
    {
        ShowCursor(false);
    }
}

void CGlobals::RemoveCaptionBarFromWindowStyle()
{
    LONG l_style = GetWindowLong(m_hwnd_main, GWL_STYLE);
    l_style = WS_POPUP;
    SetWindowLong(m_hwnd_main, GWL_STYLE, l_style);
}

void CGlobals::ReSetupWindowStyle()
{
    
    long l_style = m_windowed_mode_style;
    SetWindowLong(m_hwnd_main, GWL_STYLE, l_style);
    UpdateWindow(m_hwnd_main);          // Show the window on the screen
    
}
void CGlobals::ReconstructScreen()
{
    
    if (GetWindowedMode())
    {
        //windowed mode
        ReSetupWindowStyle();
        if (0 > m_screen->ChangeVideoMode(GetRealWindowedX(),GetRealWindowedY(), 0))
        {
            MessageBox(m_hwnd_main, "Couldn't switch to windowed mode", "Error", 0);
            PostQuitMessage(0);
            return;
        }
       
        MoveWindow(m_hwnd_main,  (GetSystemMetrics(SM_CXSCREEN)-GetRealWindowedX())/2 ,
            (GetSystemMetrics(SM_CYSCREEN)-GetRealWindowedY())/2
            , GetRealWindowedX(), GetRealWindowedY(), true);
        
    }   else
    {
        //fullscreen
        RemoveCaptionBarFromWindowStyle();
        m_screen->ChangeVideoMode(GetScreenX(), GetScreenY(), GetBPP());
        ShowCursor(false);
        
    }
    
    ShowWindow(m_hwnd_main, SW_SHOWNORMAL);    // Show the window on the screen 
    InvalidateRect(m_hwnd_main, NULL, true);
    UpdateWindow(m_hwnd_main);          // Show the window on the screen
    
}

//Random number between a defined range
int RandomRange(long i_small, long i_large)
{
    if (i_large == 0) return 0;
    if (i_large == i_small) return i_small;
    i_large++; //inclusive of large
   	return (   (((int)(rand()-1) * (i_large-i_small)) / RAND_MAX))  + i_small;
    
    //note, without the -1 from rand() it's possible to get a # 1 higher then
    //the max range.  
}

int Random(long i_max)
{
    return RandomRange(0, i_max-1);
}

void BadError(char *p_st_mess)
{
       if (GetApp()->GetWindowedMode() == false)
            {
                GetApp()->SetWindowedMode(!GetApp()->GetWindowedMode());
                GetApp()->ReconstructScreen();
                GetApp()->RestoreSurfaces();
                
            }

            MessageBox(GetApp()->GetHWND(), p_st_mess, "Stupid big fat error, sorry man!", MB_ICONERROR);
            PostQuitMessage(0);
 
}

int AltMod(int a, int b)
{
    int const rem = a % b;
    if ( (-1 % 2 == 1) || rem >= 0)
        return rem; else
        return rem + abs(b);
}
