/*
 
   InnerBody source code, created by Seth A. Robinson within 48 hours.  

   Do what you want with the source, but please credit me if you use it or the game idea.  (but who would.. ?)

   -Seth  (seth@rtsoft.com)


 */


#pragma once

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <windows.h>
#define CDXINCLUDEALL         // this define includes all headers required by CDX
#include <cdx.h>              // Header for CDX
#include <cmath>
#include <string>
#include <cassert>
#include "cdxbitmapfont.h"

using namespace std;


void LogMsg(const char *lpFormat, ...); //send a sprintf formatted command to the debug window

//class forwards
class CLevel;
class CGameLogic;
class CPlayer;
class CSoundManager;
class CParticleManager;

class CGlobals
{
public:
    
    CGlobals(); //set some defaults
    ~CGlobals();
    
    const char * GetAppName(){return (char*)&m_st_app_name;}
    void SetHWND(HWND h_hwnd){m_hwnd_main = h_hwnd;}
    HWND GetHWND(){return m_hwnd_main;}
    int GetScreenX(){return m_pnt_screen.x;}
    int GetScreenY(){return m_pnt_screen.y;}
    void UpdateTick();
    bool GetDebug(){return m_b_debug;} 
    float GetFPS(){return m_f_fps;}
    CDXScreen * GetScreen(){return m_screen;}
    bool InitGraphics();
    bool GetWindowedMode(){return m_b_windowed;}
    void SetWindowedMode(bool b_new){m_b_windowed = b_new;}
    int GetBPP(){return 32;}
    void ResetDeltaNextFrame();    
    void RestoreSurfaces();
    void ReconstructScreen();
    void SetRealWindowedX(int i_new){m_i_real_windowed_x = i_new;}
    void SetRealWindowedY(int i_new){m_i_real_windowed_y = i_new;}
    int GetRealWindowedX(){return m_i_real_windowed_x;}
    int GetRealWindowedY(){return m_i_real_windowed_y;}
    void ReSetupWindowStyle();
    void SetDefaultWindowedStyle(LONG l_style) {m_windowed_mode_style = l_style;}
    CGameLogic * GetGameLogic(){return m_p_game_logic;}
    CLevel * GetLevel(){return m_p_level;}
    void UpdateEverything();
    void RenderEverything();
    void DrawFPS();
    unsigned int GetGameTime(){return m_ui_time;} //so later I can easily change the timing
    CPlayer * GetPlayer(){return m_p_player;}
    CDXBitmapFont * GetFont(){return m_p_font1;}  
    void SetDebug(bool b_new){m_b_debug = b_new;}
    CSoundManager * GetSound(){return m_p_sound_manager;}
    CParticleManager * GetPM(){return m_p_particle_manager;}
    float GetDelta(){return m_f_delta;}
    
    
private:

    void RemoveCaptionBarFromWindowStyle();
        
    char m_st_app_name[MAX_PATH];
    HWND m_hwnd_main;
    POINT m_pnt_screen;
    unsigned int m_ui_time;
    unsigned int m_ui_time_last;
    float m_f_delta;
    float m_f_fps;
    int m_i_elapsed_frames;
    unsigned int m_ui_fps_counter;
    CDXScreen *m_screen;   
    bool m_b_windowed;
    bool m_b_reset_delta_next_frame;
    int m_i_real_windowed_x, m_i_real_windowed_y; //sizes with menu bar and such too
    LONG m_windowed_mode_style; //if not set, the default is used
    CGameLogic * m_p_game_logic;
    CLevel * m_p_level;
    CPlayer *m_p_player;
    CDXBitmapFont *m_p_font1;
    bool m_b_debug; //if true we show more debug stuff, toggle with D from in game
    CSoundManager * m_p_sound_manager;
    CParticleManager * m_p_particle_manager;
};

extern CGlobals g_glo;
CGlobals * GetApp();
int RandomRange(long i_small, long i_large);
int Random(long i_max);
void BadError(char *p_st_mess);
int AltMod(int a, int b);


    

