#include "CLevel.h"
#include "CPlayer.h"
#include "CSoundManager.h"
#include "CGameLogic.h"

CLevel::CLevel()
{
 
  //first let's init ourself a chunk o surface
  

}



CLevel::~CLevel()
{
    
}




void CLevel::Reset()
{
    m_l_wall.Reset();
    m_r_wall.Reset();
    GetApp()->GetSound()->SetSoundOnOff(C_SOUND_BAD, false);
    GetApp()->GetSound()->SetSoundOnOff(C_SOUND_GOOD, false);
    GetApp()->GetSound()->SetSoundOnOff(C_SOUND_MISS, false);
    
}

bool CLevel::IsEmpty()
{
   return (GetLeftWall()->IsEmpty() && GetRightWall()->IsEmpty());
}

void CLevel::Update()
{
  //did the player hit anything?
    if (!GetApp()->GetGameLogic()->GetShowGameScreen()) return;
    bool b_miss = false;
    bool b_hit_good = false;
    bool b_hit_bad = false;

 if (GetApp()->GetPlayer()->GetControlLeft())    
 {
   //we'll, he's trying
     m_l_wall.m_data.ProcessHit(GetApp()->GetPlayer()->GetPosY());
         
     switch (m_l_wall.GetLastWallTypeHit()) 
     {
     case C_WALL_NONE:
         b_miss = true;
         break;
     case C_WALL_SICK:
         b_hit_good = true;
         break;
     case C_WALL_HEALTHY:
         b_hit_bad = true;
      break;
     }
 }

 if (GetApp()->GetPlayer()->GetControlRight())    
 {
     //we'll, he's trying
     m_r_wall.m_data.ProcessHit(GetApp()->GetPlayer()->GetPosY());
     switch (m_r_wall.GetLastWallTypeHit()) 
     {
     case C_WALL_NONE:
         b_miss = true;
         break;
     case C_WALL_SICK:
         b_hit_good = true;
         break;
     case C_WALL_HEALTHY:
         b_hit_bad = true;
         break;
     }
 }
 
  //turn on/off sound to match this
  GetApp()->GetSound()->SetSoundOnOff(C_SOUND_BAD, b_hit_bad);
  GetApp()->GetSound()->SetSoundOnOff(C_SOUND_MISS, b_miss);
  GetApp()->GetSound()->SetSoundOnOff(C_SOUND_GOOD, b_hit_good);
  

  //calc the wall positions
  m_l_wall.Update();


  //calc the wall positions
  m_r_wall.Update();
 
}

void CLevel::Render(CDXSurface *p_surf)
{
    if (!GetApp()->GetGameLogic()->GetShowGameScreen()) return;
    
    m_l_wall.DrawWall( p_surf);
    m_r_wall.DrawWall( p_surf);
    
}