#include "CParticleManager.h"

CParticleManager::CParticleManager()
{
  m_i_index = 0;    

}

void CParticleManager::Update()
{
    
}

void CParticleManager::Render(CDXSurface *p_surf)
{

    //draw valid particles
    p_surf->Lock();

    for (int i=0; i < C_PARTICLE_BUFFER_SIZE; i++)
    {
       if (m_a_particles[i].f_y < 640)
       {
        //for speed I'm actually moving them here and not in the Update() like normal
        m_a_particles[i].f_x += m_a_particles[i].f_speed_x * GetApp()->GetDelta();
        m_a_particles[i].f_y += m_a_particles[i].f_speed_y * GetApp()->GetDelta();
        
       //apply gravity
        m_a_particles[i].f_speed_y -= C_F_GRAVITY * GetApp()->GetDelta();

        //change color
        if (m_a_particles[i].r > 1) m_a_particles[i].r--;
        if (m_a_particles[i].g > 1) m_a_particles[i].g--;
        if (m_a_particles[i].b > 1) m_a_particles[i].b--;
        
        p_surf->PutPixel(int(m_a_particles[i].f_x), int(m_a_particles[i].f_y), RGB(m_a_particles[i].b,
            m_a_particles[i].g, m_a_particles[i].r));
       }
    }

    p_surf->UnLock();
}


const int C_MIN_PARTICLE_SPEED = -20;
const int C_MAX_PARTICLE_SPEED = 20;

void CParticleManager::AddParticles(int x, int y, int i_count, byte r, byte g, byte b)
{

  for (int i=0; i < i_count; i++)
  {
    m_a_particles[m_i_index].f_x = float(x);
    m_a_particles[m_i_index].f_y = float(y);
    m_a_particles[m_i_index].f_speed_x = float(RandomRange(C_MIN_PARTICLE_SPEED, C_MAX_PARTICLE_SPEED));
    m_a_particles[m_i_index].f_speed_y = float(RandomRange(C_MIN_PARTICLE_SPEED, C_MAX_PARTICLE_SPEED));
    m_a_particles[m_i_index].r = r;
    m_a_particles[m_i_index].g = g;
    m_a_particles[m_i_index].b = b;
    
    m_i_index = AltMod(m_i_index+1, C_PARTICLE_BUFFER_SIZE);
  }

}



