#include "CPlayer.h"
#include "CLevel.h"
#include "CGameLogic.h"

CPlayer::CPlayer()
{
 ResetKeys();
 if (m_ship.Create(GetApp()->GetScreen(), "graphics\\ship.bmp", 0,0,1, CDXMEM_VIDTHENSYS) < 0)
 {
     BadError("Couldn't load ship graphic");
 }
 m_ship.SetColorKey(RGB(0,0,0));

 if (m_lightning.Create(GetApp()->GetScreen(), "graphics\\lightning.bmp", 0,0,5, CDXMEM_VIDTHENSYS) < 0)
 {
     BadError("Couldn't load lightning graphic");
 }
 m_lightning.SetColorKey(RGB(0,0,0));
 m_ul_timer_left = 0;
 m_ul_timer_right = 0;
  

}

CPlayer::~CPlayer()
{

}

void CPlayer::Restore()
{
    ResetKeys();
    m_ship.Restore();
  //  m_lightning.Restore();
}
void CPlayer::ResetKeys()
{
  m_b_jump_down = false;
  m_b_left_down = false;
  m_b_right_down = false;
}
void CPlayer::Update()
{

}

void CPlayer::BlitLeft(CDXSurface *p_surf)
{
    int i_x = GetApp()->GetLevel()->GetLeftWall()->GetX()+GetApp()->GetLevel()->GetLeftWall()->GetWidth();
   
   if (m_ul_timer_left < GetApp()->GetGameTime()) 
   {
    //time to update again

      m_lightning.SetFrame(Random(m_lightning.GetTile()->GetBlockCount()));
      m_ul_timer_left = GetApp()->GetGameTime()+RandomRange(30,50);
   }
   m_lightning.SetPos(i_x, GetPosY()-m_lightning.GetTile()->GetBlockHeight()/2);
   m_lightning.Draw(p_surf, 0, 0, CDXBLT_TRANS);
}
void CPlayer::BlitRight(CDXSurface *p_surf)
{
//   if (GetApp()->GetLevel()->GetLeftWall()->GetEnabled()
    int i_x = GetApp()->GetLevel()->GetRightWall()->GetX() -m_lightning.GetTile()->GetBlockWidth();
    
  
    if (m_ul_timer_right < GetApp()->GetGameTime()) 
    {
        //time to update again
        
        m_lightning.SetFrame(Random(m_lightning.GetTile()->GetBlockCount()));
        m_ul_timer_right = GetApp()->GetGameTime()+RandomRange(30,50);
    }
    m_lightning.SetPos(i_x, GetPosY()-m_lightning.GetTile()->GetBlockHeight()/2);
    m_lightning.Draw(p_surf, 0, 0, CDXBLT_TRANSHFLIP);

}

void CPlayer::BlitShip(CDXSurface *p_surf)
{
    m_ship.DrawTrans(p_surf, GetPosX()- (m_ship.GetBlockWidth()/2),
        GetPosY()-23);
}

void CPlayer::Render(CDXSurface *p_surf)
{
    if (!GetApp()->GetGameLogic()->GetShowGameScreen()) return;
    
   //if keys are down, drawn the lines
    if (GetControlLeft()) BlitLeft(p_surf);
    if (GetControlRight()) BlitRight(p_surf);
    BlitShip(p_surf);
    
}
