#pragma once
#include "CGlobals.h"


class CPlayer
{
  
public:
    CPlayer();
    ~CPlayer();
    
    void Update();
    void Render(CDXSurface *p_surf);
    void ResetKeys();
    
    void SetControlRight(bool b_new) {m_b_right_down = b_new;}
    void SetControlLeft(bool b_new) {m_b_left_down = b_new;}
    void SetControlJump(bool b_new) {m_b_jump_down = b_new;}

    bool GetControlRight(){return m_b_right_down;}
    bool GetControlLeft(){return m_b_left_down;}
    bool GetControlJump(){return m_b_jump_down;}


    int GetPosY() {return 240;}
    int GetPosX() {return 320;}
    
    void Restore();
        
private:
    
    void BlitShip(CDXSurface *p_surf);
    void BlitLeft(CDXSurface *p_surf);
    void BlitRight(CDXSurface *p_surf);
    
    bool m_b_left_down;
    bool m_b_right_down;
    bool m_b_jump_down;
    CDXTile m_ship;
    CDXSprite m_lightning;
    unsigned long m_ul_timer_left; //how often to animate
    unsigned long m_ul_timer_right; 
    
};
