#include "CSoundManager.h"

CSoundManager::CSoundManager()
{

    //init main sound thingie
    m_sound.Create(GetApp()->GetHWND(), false);
    //load our sounds
    if (0 > m_a_sound[C_SOUND_GOOD].Load(&m_sound, "sounds\\good.wav"))
    {
        BadError("Couldn't find a sound");
    }
    if (0 > m_a_sound[C_SOUND_BAD].Load(&m_sound, "sounds\\blast.wav"))
    {
        BadError("Couldn't find a sound");
    }

    if (0 > m_a_sound[C_SOUND_START].Load(&m_sound, "sounds\\start.wav"))
    {
        BadError("Couldn't find a sound");
    }
    if (0 > m_a_sound[C_SOUND_MISS].Load(&m_sound, "sounds\\good2.wav"))
    {
        BadError("Couldn't find a sound");
    }
    
    if (0 > m_a_sound[C_SOUND_HAPPY].Load(&m_sound, "sounds\\happy.wav"))
    {
        BadError("Couldn't find a sound");
    }
}

void CSoundManager::Play(int i_sound)
{
    assert(i_sound < C_SOUND_TOTAL && i_sound >= 0 && "Sound out of range!");

    m_a_sound[i_sound].Play();
    
}
void CSoundManager::SetSoundOnOff(int i_sound, bool b_new)
{
  assert(i_sound < C_SOUND_TOTAL && i_sound >= 0 && "Sound out of range!");

  if (b_new)
  {
      //turn it on if it wasn't already playing

    if (m_a_sound[i_sound].Playing() == 0)
    m_a_sound[i_sound].Play(DSBPLAY_LOOPING);
  } else
  {
    m_a_sound[i_sound].Stop();
  }

}