#include "CWall.h"
#include "CGameLogic.h"
#include "CParticleManager.h"


CWallData::CWallData()
{
    Reset();
  
}
void CWallData::Reset()
{
    memset(this, 0, sizeof(*this));
    
    m_i_health_min_ms = 100;
    m_i_health_max_ms = 200;
    m_i_sick_min_ms = 140;
    m_i_sick_max_ms = 400;
    m_i_output_mode = C_OUTPUT_MODE_NORMAL;
    m_i_last_wall_type_hit = C_WALL_NONE;
    m_i_ps_width = 0;
    
}

void CWallData::AddRow()
{
 
    m_i_last_jump_size++;
    m_i_top_index = AltMod(m_i_top_index-1, C_WALL_DATA_HEIGHT); //wrap it around when needed

    //first check last for any sickness missed
    switch (m_data[m_i_top_index])
    {
    case C_WALL_SICK:
        //they missed this!
         GetApp()->GetGameLogic()->IncSickMissed();
         break;
    }
    
    //add the new row type
    m_data[m_i_top_index] = m_i_pen_type;
}

void CWallData::UpdateRows()
{
  //calc mode
      
    switch (m_i_output_mode)
    {
    case C_OUTPUT_MODE_NORMAL:
        {
            if (m_timer_next_update < GetTickCount())
            {
                
                //time to update status
                int i_status = Random(2);
                switch(i_status)
                {
                case 0:
                    m_i_pen_type = C_WALL_HEALTHY;
                    m_timer_next_update = GetTickCount() + RandomRange(m_i_health_min_ms, m_i_health_max_ms);
                    break;
                case 1:
                    m_i_pen_type = C_WALL_SICK;
                    m_timer_next_update = GetTickCount() + RandomRange(m_i_sick_min_ms, m_i_sick_max_ms);
                    break;
                default:
                    assert(!"Unknown pen type");
                }
            }
            break;
        }
        
      case C_OUTPUT_MODE_NONE:
          m_i_pen_type = C_WALL_NONE;
          break;

      default:
          assert(!"Unknown output mode type");
      }
  
  //add a row?
  assert(m_i_movement_adjustment != 0 && "You need to set the speed.");
  m_i_last_jump_size = 0;
  while (m_last_tick_processed+m_i_movement_adjustment < GetTickCount())
  {
      m_last_tick_processed += m_i_movement_adjustment;
      AddRow();
  }
  
}

//we got "tagged" here since the last move
void CWallData::ProcessHit(int i_y)
{
  int i_index = AltMod(m_i_top_index+i_y, C_WALL_DATA_HEIGHT);

  //it's possible more than one line got hit, this allows fast scrolling

  for (int i = 0; i < m_i_last_jump_size; i++)
  {
      i_index = AltMod(i_index+1, C_WALL_DATA_HEIGHT);

      m_i_last_wall_type_hit = m_data[i_index];
      switch (m_data[i_index])
      {
      case C_WALL_SICK:
          //good work
          GetApp()->GetGameLogic()->IncSickHit();
          m_data[i_index] = C_WALL_HEALED;
          GetApp()->GetPM()->AddParticles(m_i_pos_x+m_i_ps_width, i_y, 2, 255,0,0);
          break;
   /*
      case C_WALL_HEALED:
          //good work
          GetApp()->GetGameLogic()->IncSickHit();
          //m_data[i_index] = C_WALL_HEALED;
          break;
    */
          
      case C_WALL_HEALTHY:
          //bad work
          GetApp()->GetGameLogic()->IncHealthHit();
          m_data[i_index] = C_WALL_DAMAGED;
          GetApp()->GetPM()->AddParticles(m_i_pos_x+m_i_ps_width, i_y,2, 30,240,0);
          break;
       }
   }
}


CWall::CWall()
{

}


CWall::~CWall()
{

}

void CWall::Update()
{
    if (m_b_disabled) return;
    m_data.UpdateRows();
}

bool CWall::IsEmpty()
{

    for (int i=0; i < C_WALL_DATA_HEIGHT; i++)
    {
        if (m_data.m_data[i] != C_WALL_NONE) return false;
    }

    //nothing currently on screen for this wall
    return true;
}
void CWall::SetHealthySpeed(int i_min, int i_max)
{
    m_data.m_i_health_min_ms = i_min;
    m_data.m_i_health_max_ms = i_max;
}

void CWall::SetSickSpeed(int i_min, int i_max)
{
    m_data.m_i_sick_min_ms = i_min;
    m_data.m_i_sick_max_ms = i_max;
}

void CWall::Reset()
{
    m_b_disabled = false;
    m_i_color_mode = 0;
    m_data.Reset();
}

void CWall::SetMovementSpeed(int i_speed)
{
    //convert to MS delay needed
    m_data.m_i_movement_adjustment = 1000/i_speed; //will make one every N MS that passes
    m_data.m_last_tick_processed = GetTickCount();
    
    
}
//well, after my speed test PutPixel directly on the back buffer is the fastest.. go figure

void CWall::DrawWall(CDXSurface * p_surf)
{
   byte r,g,b;
   float modx = 0;
   static int i_temp = 0;
   i_temp = 0;
   /*
   for (int i=0; i < 800; i++)
    {
        p_surf->FillRect(0, i, 20, i+1, RGB(++r,++g,++b));

    }
*/
    //now copy what we did over the old one
   // m_surf.DrawBlk(p_surf, 0,0, NULL);
 
if (m_b_disabled) return;
 
  p_surf->Lock();
  int i_index = m_data.m_i_top_index;
  
  for (int i=0; i < C_WALL_DATA_HEIGHT; i++)
   {
  
       switch (m_data.m_data[i_index])
       {
       case C_WALL_HEALTHY:
           r = 0; g = 200; b = 0;
         if (m_i_color_mode == 1)
         {
           r = i/4;
           g = r;
         }
         if (m_i_color_mode == 2)
         {
             b = i/4;
             g = r;
         }
         break;
       case C_WALL_SICK:
           r = 200; g = 0; b = 0;
           break;
       case C_WALL_HEALED:
           r = 40; g = 100; b = 0;
           break;
       case C_WALL_DAMAGED:
           r = 200; g = 80; b = 0;
           break;
       case C_WALL_NONE:
           //advance to the next one
           i_index = AltMod(i_index+1, C_WALL_DATA_HEIGHT);
           continue; //skip it, nothing here
       default:
           assert(!"don't know how to draw this wall type");
       }
       
       if (m_i_movement_style == 1)
       {
           //special movement mod
            modx = float(sin(i_index)*30*sin(i_index));
       } else
       if (m_i_movement_style == 2)
       {
           //special movement mod
           modx = float((sin(i_index)*4)*cos(i_index)*3);
       } else
       if (m_i_movement_style == 3)
       {
           //special movement mod
           modx = float((sin(i_index/130)*3)*cos(i_index)*4);
       } else
       if (m_i_movement_style == 4)
       {
           //special movement mod
           modx = float(sin(i/3))* (i/3)/5;
       } 
           if (m_i_movement_style == 5)
           {
           //special movement mod
                i_temp++;               

                if (i_temp < 110)
                {
                    modx+=0.1f;
                } else
                {
                    modx -= 0.1f;
                    if (modx < 1)
                    {
                        modx = 0;
                        i_temp = 0;
                    }
                    
                }
        }
       
       for (int h=0; h < GetWidth(); h++)
       {
           
           p_surf->PutPixel(m_data.m_i_pos_x +h+int(modx), 0+i, RGB(b,g,r));
           if (r < 245)
               r += 15;
           if (g < 245)
               g += 15;
           if (b < 245)
               b += 15;
           
       }
     //advance to the next one
      i_index = AltMod(i_index+1, C_WALL_DATA_HEIGHT);
       
   }
   p_surf->UnLock();
  
 
}