#include "CGlobals.h"


//this class is resposible for keeping track of the data for the walls of the 'tunnel' and
//also rendering it.

#define C_WALL_DATA_HEIGHT 480

enum
{
    C_OUTPUT_MODE_NORMAL,
        C_OUTPUT_MODE_NONE
};

//info on the wall types

enum
{
  C_WALL_NONE = 0, //nothing there
      C_WALL_HEALTHY,
      C_WALL_SICK,
      C_WALL_HEALED,
      C_WALL_DAMAGED

};


//this uses a circular buffer scheme to keep track of where the good and bad flesh (?) is
class CWallData
{
    //revolving buffer for the wall data
public:
  
    CWallData();
    
    void UpdateRows();
    void AddRow();
    void ProcessHit(int i_y);
    void Reset();
    

    int m_data[C_WALL_DATA_HEIGHT]; //wall info
    int m_i_top_index; //points at the top of the data. 
    int m_i_last_jump_size; //how many rows were added during the last update
    
    int m_i_health_min_ms,  m_i_health_max_ms;
    int m_i_sick_min_ms,  m_i_sick_max_ms;
    unsigned long m_timer_next_update;
    int m_i_pen_type;
    unsigned int m_last_tick_processed; //for calculating how many new bars to add
    unsigned int m_i_movement_adjustment;
    int m_i_last_wall_type_hit;
    int m_i_output_mode;
    int m_i_pos_x;
    int m_i_width;
    int m_i_ps_width;
    
    
};

class CWall
{
public:
    CWall();
    ~CWall();
    void DrawWall(CDXSurface * p_surf);
    void SetDisabled(bool b_new) {m_b_disabled = b_new;}
    void Reset();
    void SetHealthySpeed(int i_min, int i_max);
    void SetSickSpeed(int i_min, int i_max);
    void SetMovementSpeed(int i_speed); //number of rows per second
    int GetX(){return m_data.m_i_pos_x;}
    int GetWidth() {return m_data.m_i_width;}
    void SetX(int i_new){m_data.m_i_pos_x = i_new;}
    void SetWidth(int i_new){m_data.m_i_width = i_new; }
    void SetPSWidth(int i_new){m_data.m_i_ps_width = i_new; }
    void Update();
    void SetMovementStyle(int i_new){m_i_movement_style = i_new;}
    int GetLastWallTypeHit(){return m_data.m_i_last_wall_type_hit;}
    void SetOutputMode(int i_mode){m_data.m_i_output_mode = i_mode;}
    bool IsEmpty();
    void SetColorMode(int i_new) {m_i_color_mode = i_new;}

    CWallData m_data;
     bool m_b_disabled;
    int m_i_movement_style;
    int m_i_color_mode;
    
};
