#include "CGlobals.h"
#include "CPlayer.h"
#include "CGameLogic.h"


static long __stdcall WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    
    switch(message)
    {
     case WM_SYSKEYDOWN:
        if (wParam == VK_RETURN)
        {
            //toggle between windowed mode or whatever
            LogMsg("Toggling fullscreen.");
            GetApp()->SetWindowedMode(!GetApp()->GetWindowedMode());
            GetApp()->ReconstructScreen();
            GetApp()->RestoreSurfaces();
        }
        break;  
        
    case WM_KEYDOWN:               // If the user pressed a key
        switch(wParam)
        {
        case VK_ESCAPE:
            
            if (GetApp()->GetGameLogic()->GetGameMode() == C_MODE_TITLE)
            {
                PostQuitMessage(0);
                
            } else
            {
                //quit back to title screen
                GetApp()->GetGameLogic()->SetGameMode(C_MODE_TITLE);
            }
            break;
            
        case VK_LEFT:
            GetApp()->GetPlayer()->SetControlLeft(true);
            break;
        case VK_RIGHT:
            GetApp()->GetPlayer()->SetControlRight(true);
            break;
        case 'D':
            GetApp()->SetDebug(!GetApp()->GetDebug());
            break;
        case ' ':
            GetApp()->GetGameLogic()->HitSpace();
            break;
        case 'C':
            GetApp()->GetGameLogic()->ContinueLastGame();
            break;
        case 187:
            GetApp()->GetGameLogic()->CheatModLevel(1);
            break;
        case 189:
            GetApp()->GetGameLogic()->CheatModLevel(-1);
            break;
        
#ifdef _DEBUG
        default:
            
            LogMsg("Got %d", wParam);
#endif
        }
    break;

 case WM_KEYUP:               // If the user pressed a key
        switch(wParam)
        {
        case VK_LEFT:
            GetApp()->GetPlayer()->SetControlLeft(false);
            break;
        case VK_RIGHT:
            GetApp()->GetPlayer()->SetControlRight(false);
            break;
        case VK_UP:
            GetApp()->GetPlayer()->SetControlJump(false);
            break;
            
        }
        
        break; 
        
        case WM_DESTROY:
            
            PostQuitMessage(0); 
            break;         
            
        case WM_ACTIVATEAPP:
           if (wParam)
            GetApp()->RestoreSurfaces(); //any extra surfaces we have to handle ourself 
            break;
            
    }
    
    return DefWindowProc(hWnd, message, wParam, lParam); 
}



bool InitApp(HINSTANCE hInstance)
{
   //do the windows crap
    WNDCLASS WndClass;                                 // Create the window object
    WndClass.style = CS_HREDRAW | CS_VREDRAW;          // Tell windows to send a paint message 
    //   when the window is resized
    WndClass.lpfnWndProc = WinProc;                    // Sets the name of the WinProc function, can be changed, don't
    WndClass.cbClsExtra = 0; 
    WndClass.cbWndExtra = 0;
    WndClass.hInstance = hInstance;                      // Send it our handle instance
    WndClass.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDC_ARROW));
     WndClass.hCursor = LoadCursor(0, IDC_ARROW);       // Sets the cursor to a standard windows arrow
    WndClass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);   // Sets the windows background as black
    WndClass.lpszMenuName = 0;                         // You would load a menu here, but we don't have one
    WndClass.lpszClassName = GetApp()->GetAppName();              // Send it our class name
    RegisterClass(&WndClass);                          // Registers the class with windows
  
    
    DWORD dwExStyle=NULL;//WS_EX_TOPMOST; // Window Extended Style
    
    DWORD dwStyle= WS_MINIMIZEBOX |WS_SYSMENU| DS_CENTER; // Windows Style
    
    RECT WindowRect = {0,0,GetApp()->GetScreenX(), GetApp()->GetScreenY()};
    
    GetApp()->SetHWND(CreateWindowEx(         // This creates the window but it is still not shown 
        dwExStyle, 
        GetApp()->GetAppName(), 
        GetApp()->GetAppName(), 
        dwStyle,   // Set window options
        CW_USEDEFAULT, 
        CW_USEDEFAULT, 
        WindowRect.right-WindowRect.left,       // Set window width 
        WindowRect.bottom-WindowRect.top,       // Set window height 
        NULL, 
        NULL, 
        hInstance,
        NULL)); 
  
    if(!GetApp()->GetHWND()) return FALSE;           // If the window creation failed, return FALSE
    
    //well, for some reason AdjustWindowRectEx doesn't really return the correct results, so we have to do this..
    RECT rect_client, rect_window;
    GetClientRect(GetApp()->GetHWND(), &rect_client);
    GetWindowRect(GetApp()->GetHWND(), &rect_window);
    
    //figure out the difference
    int i_border_x = (rect_window.right - rect_window.left) - rect_client.right;
    int i_border_y = (rect_window.bottom - rect_window.top) - rect_client.bottom;
    
    WindowRect.right = GetApp()->GetScreenX() + i_border_x;
    WindowRect.bottom = GetApp()->GetScreenY() + i_border_y;
    
    GetApp()->SetRealWindowedX(WindowRect.right-WindowRect.left); //remember the sizes WITH the extra window crap too
    GetApp()->SetRealWindowedY(WindowRect.bottom-WindowRect.top); //remember the sizes WITH the extra window crap too
    
    MoveWindow(GetApp()->GetHWND(),  (GetSystemMetrics(SM_CXSCREEN)-WindowRect.right)/2 ,
        (GetSystemMetrics(SM_CYSCREEN)-WindowRect.bottom)/2
        , WindowRect.right, WindowRect.bottom, false);
    ShowWindow(GetApp()->GetHWND(), SW_SHOW);    // Show the window on the screen 
    
    UpdateWindow(GetApp()->GetHWND());          // Show the window on the screen

    //init the graphics too
    
    return GetApp()->InitGraphics();
}


#define C_LOCKED_FPS 0 //change to 30 or so to see it locked at a certain FPS

void MainLoop()
{
    static unsigned int m_ui_timer = 0;
  
    if (m_ui_timer <= GetTickCount() )
    {
       GetApp()->UpdateTick();
       GetApp()->UpdateEverything();
        GetApp()->RenderEverything();
        m_ui_timer = GetTickCount()+C_LOCKED_FPS ;
    }

    Sleep(0);
}



void getdir(char final[])
{
    //Using	GetModuleFileName instead of ParamStr, works with Win2000/nt.
    char dir[MAX_PATH];
    char path[MAX_PATH];
    GetModuleFileNameA(NULL, path, MAX_PATH);
    char c_cur = 0;
    
    for (int k=strlen(path);path[k] != '\\'; k--)
    {
        c_cur = k;
    }
    strcpy(dir, "");
    //copy file name
    strncat((char*)&dir, &path[c_cur], strlen(path)-c_cur);
    path[c_cur] = 0; //truncate
    strcpy(final, path);
}

int __stdcall WinMain(HINSTANCE hInstance, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow) 
{
       char dir_final[MAX_PATH];
        getdir(dir_final);
        //switch to dir run.exe is in
        chdir(dir_final);
  
        MSG msg; 
     
    if(!InitApp(hInstance)) return FALSE; 
    
    
    // This little section resends all the messages in the message queue,
    // After it is done processing them, it then calls cdx_DoFrame(), our main program loop
 
    while(1)
    {
        if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE)) {
            if(!GetMessage(&msg, NULL, 0, 0 )) return msg.wParam;
            TranslateMessage(&msg); 
            DispatchMessage(&msg); 
        } else {
            MainLoop();
         }
    }
    
} 
