
#pragma once

#include "main.h"
using namespace std;

#include "MessageDispatcher.h"

enum
{
  C_TYPE_UNKNOWN,
      C_TYPE_FLY,
	  C_TYPE_SWATTER,

};

class Entity
{
public:

    Entity();
    virtual ~Entity();
    virtual void Update(float step); 
    virtual void Render();
    virtual void OnMessage(Message &msg);
    
    
    int GetID() const {return m_ID;}
    int  GetType()const{return m_type;}
    void SetType(int newType){m_type = newType;}
    void SetName(std::string name) {m_name = name;}
    const std::string & GetName(){return m_name;} 
    bool GetDeleteFlag(){return m_deleteFlag;}
    void SetDeleteFlag(bool bNew) {m_deleteFlag = bNew;}
    int GetSort(){return m_sort;}
    void SetSort(int sort) {m_sort = sort;}
    int GetRadius() {return m_radius;}
	bool TouchingPlayer();
	void SetPosTarget(const CL_Vector2 &v);
 
	CL_Vector2 m_vPosition;
    
    bool m_bScaleToNothing;
    bool m_bScaleUp;
    
	bool m_bPosTargetActive;
	CL_Vector2 m_vPosTarget;

    bool m_bFadeAlphaTo;
    float m_alphaTarget;
    float m_alpha;
    float m_alphaFadeSpeed;

protected:
    
    int         m_ID;
    bool m_deleteFlag; 
    int         m_type;
    static int  m_nextID;
    std::string m_name; 
    int m_sort; //where we should be in the order of what is drawn/updated
    int m_radius;
  
	CL_Sprite *m_sprite; 
 
	CL_Vector2 m_vScale;
    CL_Vector2 m_vVelocity;
    CL_Vector2 m_vHeading; //where we're facing, normalized
};


