
#pragma once

#pragma warning (disable:4786)

#include <list>

class Entity;
#include "main.h"
#include "MessageDispatcher.h"

class MyEntityManager
{
public:

    MyEntityManager();
    ~MyEntityManager();
    
    bool Init();
    void Kill();

    void Render();
    void Update(float step);
    void Add(Entity *pEnt);
    bool TagEntityForDeletionByName (std::string name);
    void ProcessSortRequests();
    Entity * TouchedEntity(int entType, CL_Vector2 vPos, int radius);
    void OnMessage(Message &msg);

private:

    std::list<Entity*>  m_Entities;
    void RemoveEntitiesTaggedForDeletion();

};

