#include "EntShow.h"
#include "GameLogic.h"

EntShow::EntShow()
{
	m_bKillOnFinish = false;
}

EntShow::~EntShow()
{
}

void EntShow::SetupText(const string &text, CL_Vector2 v)
{
	m_msg = text;
	m_vPosition = v;
}

void EntShow::SetupPic(const string &file, CL_Vector2 v)
{
	SAFE_DELETE(m_sprite);

	CL_Surface s(file);

	CL_SpriteDescription d;
	d.add_frame(s.get_pixeldata());

	std::list<CL_SpriteDescription::FramePair> *pFramePairList =  (std::list<CL_SpriteDescription::FramePair>*)&d.get_frames();

	CL_Rect picSrcRect = CL_Rect(0,0,s.get_width(), s.get_height());
	pFramePairList->begin()->second = picSrcRect;
	m_sprite = new CL_Sprite(d);
	m_sprite->set_alignment(origin_top_left,0,0);
	m_vPosition = v;
}


void EntShow::OnMessage(Message &msg)
{
	switch(msg.m_msg)
	{
	case C_MESSAGE_ROUND_ENDED:
		if (m_bKillOnFinish)
		{
			m_bFadeAlphaTo = true;
			m_alphaTarget = 0;
			GetGameLogic->GetMessageDispatcher()->SendMsg(C_MESSAGE_KILL_ENTITY, 50, this);
		}
		break;
	}

	Entity::OnMessage(msg);
}

void EntShow::Render()
{
	if (m_msg.empty())
	{
		Entity::Render();
	} else
	{
		//show the text
		GetApp()->GetFont(C_FONT_MAIN)->set_alignment(origin_center);
		GetApp()->GetFont(C_FONT_MAIN)->draw(m_vPosition.x, m_vPosition.y, m_msg);
	}
}