// ***************************************************************
//  Swatter - date created: 04/30/2006
//  Programmer(s):  Seth A. Robinson (seth@rtsoft.com) 
//  Copyright (C) 2006 Robinson Technologies - All Rights Reserved

#ifndef Swatter_HEADER_INCLUDED // include guard
#define Swatter_HEADER_INCLUDED  // include guard

#include "Entity.h"

class Swatter: public Entity
{
public:

    Swatter();
    virtual ~Swatter();

	virtual void Update(float step);

	void OnMouseMove(const CL_InputEvent &key);
	void OnButtonDown(const CL_InputEvent &key);
	void SetCursorLimit(const CL_Rect &r) {m_rectLimit = r;}
	void RanOutOfTime();

	enum eMovement
	{
		C_MOVE_ANYWHERE,
		C_MOVE_RIGHT_ONLY,
		C_MOVE_LEFT_ONLY

	};

	void SetMovementMode(eMovement m) {m_movementMode = m;}

protected:

private:

	CL_SlotContainer m_slots;
	CL_Point m_vecLastMousePos;
	eMovement m_movementMode;
	CL_Rect m_rectLimit;
};

extern Swatter *g_pSwatter;

#endif                  // include guard